
#ifndef APP_ALGO_ALGO_H
#define APP_ALGO_ALGO_H

#include <stdbool.h>
#include <stdint.h>


typedef struct
{
	int32_t x;
	int32_t y;
	int32_t z;
}AlgoAxesData_t;

typedef struct
{
	int32_t 		hrData;
	int32_t			reliability;
}AlgoOutputData_t;

typedef struct
{
	AlgoAxesData_t	axes;
	int32_t 		ppgSample;
	int32_t			envSample;
}AlgoInputData_t;

void Algo_Init(void);
void Algo_Input(AlgoInputData_t *pInputData,int32_t gaptime);
void Algo_Output(AlgoOutputData_t *pOutputData);



#endif /* APP_ALGO_ALGO_H_ */



